/*	zap technologies - copyright 1999
/*	http://www.zaptech.com
/*
/*  why: uncommenting thr (*nodelink)->prev dispose code causes a memeory leak?
/*
/*  1999-10-31 - added support for Group node
/*  1999-04-04 - removed daft()
/*  1999-03-21 - overhauled for Universal Headers 3.X
/*  1999-02-05 - overhauled for VN_NodeLink use
/*  1998-09-22 - VNM_DISPOSE method also disposes
/*    referenced define Node label char string
/*  1998-01-19 - created
/*
/*  Most routines return 0 if an error occurs.  Many routines will
/*  set global string pointer errorMsg if they encounter an error.
*/

/*  headers  */
#include <Windows.h>
#include "myio.h"
#include "vrml.h"
#define H_TWIRL
//  #define H_TWIRL_TV  //  debug only?
#include "twirl.h"
//  #undef H_TWIRL_TV
#undef H_TWIRL
#define H_MODEL_PROTOS
#include "models.h"
#undef H_MODEL_PROTOS


/*  local function prototypes  */
struct VN_NodeLink **getChildNodeLink(struct VN_Nod *node);
void SetDefaults(struct VN_Nod *node);


/*  global variables  */
struct VN_FIELDDATATYPEINFO fieldTypeInfo[] = {
	/*  size of data unit, number of instances (0 if simply a pointer to unique data)  */
	/*  this table be ordered the same as enumerated field datatypes  */
	sizeof(VDT_NODELINKPTR), 0,
	sizeof(VDT_NODELINKPTR), 0,
	sizeof(VDT_NODELINKPTR), 0,
	sizeof(char *),          0,
	sizeof(VDT_FLOAT),       1,
	sizeof(VDT_FLOAT *),     0,
	sizeof(VDT_VEC3F),       3,
	sizeof(VDT_VEC3F *),     0,
	sizeof(VDT_ROTATION),    4,
	sizeof(VDT_INT32),       1,
	sizeof(VDT_INT32 *),     0
	};


struct VN_FIELDINFO fieldInfo_Root[] = {
	VNDT_MFNODE, "nodes"
	};

struct VN_FIELDINFO fieldInfo_Viewpoint[] = {
	VNDT_RESERVEDPTR, NULL,
	VNDT_RESERVEDPTR, NULL,
	VNDT_RESERVEDPTR, NULL,
	VNDT_SFFLOAT,     "fieldOfView",
	VNDT_SFROTATION,  "orientation",
	VNDT_SFVEC3F,     "position",
	VNDT_CSTRING,     "description"
	};

struct VN_FIELDINFO fieldInfo_Transform[] = {
	VNDT_MFNODE,      "children",
	VNDT_SFROTATION,  "rotation",
	VNDT_SFVEC3F,     "translation"
	};

struct VN_FIELDINFO fieldInfo_Group[] = {
	VNDT_MFNODE,      "children"
	};

struct VN_FIELDINFO fieldInfo_Shape[] = {
	VNDT_SFNODE, "appearance", 
	VNDT_SFNODE, "geometry"
	};

struct VN_FIELDINFO fieldInfo_Box[] = {
	VNDT_SFVEC3F,     "size"
	};

struct VN_FIELDINFO fieldInfo_Cylinder[] = {
	VNDT_SFFLOAT,     "height",
	VNDT_SFFLOAT,     "radius",
	VNDT_BOOL0,       "top",
	VNDT_BOOL1,       "bottom",
	VNDT_BOOL2,       "side"
	};

struct VN_FIELDINFO fieldInfo_IndexedFaceSet[] = {
	VNDT_SFNODE,       "coord",
	VNDT_SFINT32,      NULL,
	VNDT_MFINT32,      "coordIndex",
	VNDT_SFINT32,      NULL
  	};

struct VN_FIELDINFO fieldInfo_Coordinate[] = {
	VNDT_MFVEC3F, "point"
	};


/*  these should have the same order as the enumerated vrml node types  */
/*  node add() should be checked to insure child nodes are recognized during parse  */
/*  matchNode() should be checked to insure nodes are detected during parse  */
struct VN_STRUCTINFO nodeInfo[] = {
	"Unsupported",    NULL,                         VNT_UNSUPPORTED,    0, sizeof (struct VN_Nod),  0,
	"Root",           &fieldInfo_Root[0],           VNT_ROOT,           1, sizeof (struct VN_Root),
	                  VNF_FERTILE,
	"Viewpoint",      &fieldInfo_Viewpoint[0],      VNT_VIEWPOINT,      7, sizeof (struct VN_Viewpoint),
	                  VNF_ISBINDABLE,
	"Transform",      &fieldInfo_Transform[0],      VNT_TRANSFORM0,     3, sizeof (struct VN_Transform0),
	                  VNF_FERTILE,
	"Group",          &fieldInfo_Group[0],          VNT_GROUP,          1, sizeof (struct VN_Group),
	                  VNF_FERTILE,
	"Shape",          &fieldInfo_Shape[0],          VNT_SHAPE,          2, sizeof (struct VN_Shape),
	                  VNF_FERTILE,
	"Appearance",     NULL,                         VNT_APPEARANCE,     1, sizeof (struct VN_Appearance), 0,
	"Box",            &fieldInfo_Box[0],            VNT_BOX,            1, sizeof (struct VN_Box), 0,
	"Cylinder",       &fieldInfo_Cylinder[0],       VNT_CYLINDER,       5, sizeof (struct VN_Cylinder),
	                  VNF_CYLINDER_TOP + VNF_CYLINDER_BOTTOM + VNF_CYLINDER_SIDE,
	"IndexedFaceSet", &fieldInfo_IndexedFaceSet[0], VNT_INDEXEDFACESET, 4, sizeof (struct VN_IndexedFaceSet),
	                  VNF_FERTILE,
	"Coordinate",     &fieldInfo_Coordinate[0],     VNT_COORDINATE,     1, sizeof (struct VN_Coordinate), 0
	};


/*  misc vrml scene graph methods  */
/*  note: does not check for bad pointers  */
vrml(struct VN_NodeLink **nodelink, short method, short value) {
	struct VN_Nod *temp;
	struct VN_NodeLink *templink;
	struct VN_NodeLink **temphandle;
	short success = 0;
	short i;

	switch (method) {
	  case VNM_ALLOC:
		/*  Allocate link, allocate node, connect node to link, set node default
		/*  values, return *link.  value = type of node to allocate.
		/*  Don't use this to allocate just a link, instead inline
		/*  NewPtr(...(sizeof struct (VN_NodeLink)))  */
		if (nodelink) {
			*nodelink = (struct VN_NodeLink *) NewPtrClear(sizeof (struct VN_NodeLink));
			if (!(*nodelink))
				goto erralloc;
			temp = (struct VN_Nod *) NewPtrClear(nodeInfo[value].size);
			if (!temp) {
				DisposePtr((char *) nodelink);
				goto erralloc;
				}
			temp->type = value;
			temp->flags = nodeInfo[value].flags;
			if (statDoc.winPtrx)
				wprintf(&statDoc, "\nvrml() alloc node %s %lx", nodeInfo[temp->type].name, temp->define);
			(*nodelink)->node = temp;
			(*nodelink)->node->use = 1;
			SetDefaults(temp);
			success = 1;
			}
		else
erralloc:	errorMsg = "vrml(VNM_ALLOC) Failure";
		break;
	  case VNM_CHILDADD:
		/*  (*nodelink) = nodelink of child to add
		/*  (*nodelink)->parent = parent nodelink to add child to
		/*  value = 0: add node, error means not added
		/*          1: check if child is supported, error means not supported  */
		temphandle = getChildNodeLink((*nodelink)->parent->node);
		if (temphandle == 0)
			goto exit;
		if (value == 0) {
			templink = temphandle[0];
			if (templink) {
				/*  first child present, place *node at end of sibling chain  */
				while (templink->next)
					templink = templink->next;
				templink->next = *nodelink;
				(*nodelink)->prev = templink;
				}
			else {
				/*  no children yet, make *node first child  */
				temphandle[0] = *nodelink;
				}
			if (statDoc.winPtrx) wprintf(&statDoc, "\nvrml() add child node %s to %s",
			  nodeInfo[(*nodelink)->node->type].name,
			  nodeInfo[(*nodelink)->parent->node->type].name);
			}
		success = 1;
		break;
	  case VNM_BIND:
		lwprintf(&statDoc, "\nvrml bind node %s", nodeInfo[(*nodelink)->node->type].name);
		switch ((*nodelink)->node->type) {
		  case VNT_VIEWPOINT:
			/*  check if this view's rootview field is valid  */
			if (!(templink = ((struct VN_Viewpoint *) (*nodelink)->node)->root)) {
				goto errlink;
				}
			if (templink->node->type != VNT_ROOT) {
errlink:		errorMsg = "vrml(VNM_BIND) Failure";
				goto exit;
				}
			/*  link into a continuous ring  */
			temp = (*nodelink)->node;
			if (((struct VN_Root *) templink->node)->views) {
				((struct VN_Viewpoint *) temp)->nextview =
				  ((struct VN_Root *) templink->node)->views;
				templink = ((struct VN_Root *) templink->node)->views;
				((struct VN_Viewpoint *) temp)->prevview =
				  ((struct VN_Viewpoint *) templink->node)->prevview;
				((struct VN_Viewpoint *) templink->node)->prevview = *nodelink;
				templink = ((struct VN_Viewpoint *) (*nodelink)->node)->prevview;
				((struct VN_Viewpoint *) templink->node)->nextview = *nodelink;
				}
			else {
				((struct VN_Root *) templink->node)->views =
				  ((struct VN_Viewpoint *) temp)->prevview =
				  ((struct VN_Viewpoint *) temp)->nextview = *nodelink;
				templink->node->flags |= VNF_FLDCHG;  /*  Root field changed  */
				}
			success = 1;
			break;
		  default:
			success = 1;
			}
		break;
	  case VNM_UNBIND:
		lwprintf(&statDoc, "\nvrml unbind node %s", nodeInfo[(*nodelink)->node->type].name);
		switch ((*nodelink)->node->type) {
		  case VNT_VIEWPOINT:
			temp = (*nodelink)->node;
			if ((*nodelink) == ((struct VN_Viewpoint *) temp)->nextview)
				((struct VN_Root *) ((struct VN_Viewpoint *) temp)->root->node)->views = 0;
			else {
				templink = ((struct VN_Viewpoint *) temp)->prevview;
				((struct VN_Viewpoint *) templink->node)->nextview =
				  ((struct VN_Viewpoint *) temp)->nextview;
				templink = ((struct VN_Viewpoint *) temp)->nextview;
				((struct VN_Viewpoint *) templink->node)->prevview =
				  ((struct VN_Viewpoint *) temp)->prevview;
				}
			((struct VN_Viewpoint *) temp)->nextview =
			  ((struct VN_Viewpoint *) temp)->prevview = 0;
			/*  break  */
		  default:
		  	success = 1;
		  }
		break;
	  case VNM_DISPOSE:
		if (*nodelink == 0)
			goto errdisp;
		temp = (*nodelink)->node;
		if (temp == 0) {
errdisp:	errorMsg = "vrml(VNM_DISPOSE) bad args";
			goto exit;
			}
		if (temp->flags & VNF_ISBINDABLE)
			vrml(nodelink, VNM_UNBIND, 0);
		/*  dispose children nodes  */
		i = nodeInfo[temp->type].fields;
		while (i--) {
			(struct VN_FIELDINFO *) templink = nodeInfo[temp->type].fi;
			switch (((struct VN_FIELDINFO *) templink)[i].datatype) {
			  case VNDT_SFNODE:
			  case VNDT_MFNODE:
//				(struct VN_NodeLink **) templink = &(((struct VN_Root *) temp)->nodes) + i;
				if (*(&(((struct VN_Root *) temp)->children) + i))
					vrml(&(((struct VN_Root *) temp)->children) + i, VNM_DISPOSE, 0);
				}
			}
		/*  Dispose all siblings!  Was caller expecting this?  */
		/*  caller should isolate node from siblings if only it  */
		/*  should be disposed  */
		templink = (*nodelink)->next;
		if (templink) {
//			doWindowStat(TSW_REPORTMEM);
			vrml(&((*nodelink)->next), VNM_DISPOSE, 0);
			}
		/*  Dispose NodeLink  */
//		templink = (*nodelink)->prev;  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//		if (templink)  /*  ERROR!!  for some reason this causes a memory leak  */
//			templink->next = (*nodelink)->next;  /*  this SHOULD be NULL now  */
		DisposePtr((char *) *nodelink);
		*nodelink = 0;
		/*  check use count, if zero dispose node  */
		lwprintf(&statDoc, "\nvrml dispose node use %lx", temp->use);
		temp->use -= 1;
		if (temp->use == 0) {
			/*  dispose misc data fields  */
			if (temp->define) {
				lwprintf(&statDoc, "%s DEF %s", nodeInfo[temp->type].name, temp->define);
				DisposePtr((char *) temp->define);
				}
			else
				lwprintf(&statDoc, "%s", nodeInfo[temp->type].name);
			lwprintf(&statDoc, "\nvrml dispose node %lx", temp->model);
			DisposeModels(temp, 0);
			switch (temp->type) {
			  case VNT_VIEWPOINT:
				if (((struct VN_Viewpoint *) temp)->description) {
					DisposePtr((char *) ((struct VN_Viewpoint *) temp)->description);
					}
			  case VNT_INDEXEDFACESET:
				if (((struct VN_IndexedFaceSet *) temp)->coordIndex) {
					DisposePtr((char *) ((struct VN_IndexedFaceSet *) temp)->coordIndex);
					}
			  case VNT_COORDINATE:
				if (((struct VN_Coordinate *) temp)->point) {
					DisposePtr((char *) ((struct VN_Coordinate *) temp)->point);
					}
				}
			DisposePtr((char *) temp);
			}
		break;
	  default:
		if (statDoc.winPtrx) wprintf(&statDoc, "\nvrml: undefined method");
		}
exit:
	return (success);
	}


struct VN_NodeLink **getChildNodeLink(struct VN_Nod *node) {
	struct VN_NodeLink **success = 0;

	/*  */
	switch (node->type) {
	  case VNT_SHAPE:
		if (node->field == VNT_SHAPE_APPEARANCE)
			success = &((struct VN_Shape *) node)->appearance;
		else if (node->field == VNT_SHAPE_GEOMETRY)
			success = &((struct VN_Shape *) node)->geometry;
		break;
	  case VNT_TRANSFORM0:
		if (node->field == VNT_TRANSFORM_CHILDREN)
			success = &((struct VN_Root *) node)->children;
		break;
	  case VNT_GROUP:
		if (node->field == VNT_GROUP_CHILDREN)
			success = &((struct VN_Root *) node)->children;
		break;
	  case VNT_INDEXEDFACESET:
		if (node->field == VNT_INDEXEDFACESET_COORD)
			success = &((struct VN_IndexedFaceSet *) node)->coord;
		break;
	  case VNT_ROOT:
		if (node->field == VNT_ROOT_CHILDREN)
			success = &((struct VN_Root *) node)->children;
		break;
		}
	return (success);
	}


void SetDefaults(struct VN_Nod *node) {

	switch (node->type) {
	  case VNT_VIEWPOINT:
		((struct VN_Viewpoint *) node)->position.z = 10.0;
		break;
	  case VNT_BOX:
		((struct VN_Box *) node)->size[0] = 2.0;
		((struct VN_Box *) node)->size[1] = 2.0;
		((struct VN_Box *) node)->size[2] = 2.0;
		break;
	  case VNT_CYLINDER:
		((struct VN_Cylinder *) node)->height = 2.0;
		((struct VN_Cylinder *) node)->radius = 1.0;
		}
	}
