/*	zap technologies - copyright 1999
/*	http://www.zaptech.com
/*
/*  twirl
/*
/*  This file contains the main startup, cleanup, and event loop code.
/*
/*  1999-10-03 - created global microTicks to show elapsed
/*               microseconds since system boot
/*  1999-03-21 - overhauled for Universal Headers 3.X
/*  1998-07-14 - broke doWindowView() into seperate file
/*  1997-09-09 - dynamic memory allocation & multiple 3D windows
/*  1997-08-28 - added crude open file function
/*  1997-07-14 - streamlined menus
/*  1997-06-13 - disabled TEInit(), InitDialogs(), InitCursor(),
/*      added greeting window
/*  1997-07-06 - now creates mesh model successfully
/*  1997-07-02 - broke myio.c, models.c into seperate files
/*  1997-06-30 - tuned Init4boxModel(), randomized Random() seed
/*  1997-06-08 - created clone of boxfred
/*
/*  Note:
/*  - most routines return 0 if an error occurs
/*  - many routines will set global string pointer errorMsg
/*    if they encounter an error
*/


/*  headers  */
#include <Windows.h>
#include <Timer.h>
#include <Fonts.h>
#include <ToolUtils.h>
#include <Sound.h>
#include <Devices.h>
#include <Menus.h>
#include <DiskInit.h>
#include <QuickDraw.h>
#include <QD3D.h>

#include "myio.h"
#include "vrml.h"
#include "parse.h"
#define H_TWIRL_TV
#include "twirl.h"
#undef H_TWIRL_TV


/*  function prototypes  */
static int Init();
static void MainEventLoop(void);
void Cleanup();
void waitForKey(void);
int greetWindow(void);
doWindowAbout(int method);
void About(int w);

/*  global variables  */
WindowPtr aboutWindow = 0;
struct wprintDocument statDoc = { 0 };
Handle menuBarHandle;
MenuHandle mh0, mh1, mh2;
short flags = F_LOG | F_WAIT;
short qtyOpen3D = 0;  /*  number of simultaneous 3D windows open  */
TQ3Status statusQD3D;
struct UnsignedWide microTicks;  /*  microseconds since system boot  */
char *errorMsg = 0;
char aboutText[] = ZAPTECHCOPYSTR ZAPTECHURLSTR;
char version[] = VERSIONSTR;


/*  main  */
int main() {
	if (!(Init()))
		goto exit;
	/*  auto run twirl and update menus  */
	if (!(flags & F_WAIT)) {
		if (!doWindowView(TW_INIT, 0))
			doWindowStat(TSW_ERRORMSG);
		}
	EnableItem(mh0, TMA_ABOUT);
	EnableItem(mh1, 0);
	DrawMenuBar();
	/*  Main Event Loop  */
	MainEventLoop();
	if (Q3Exit() == kQ3Failure) {
		errorMsg = "Q3Exit() failed";
		doWindowStat(TSW_ERRORMSG);
		}
exit:
	Cleanup();
	return(0);
	}


/*  Init  */
int Init() {
	int initok;

	MaxApplZone();
	for (initok = MAX3DVIEWS * 2; initok; initok--)
		MoreMasters();

	InitGraf(&qd.thePort);  /*  initialize QuickDraw  */
	InitFonts;
	InitWindows();
	InitMenus();
//	TEInit();
//	InitDialogs(0L);
//	InitCursor();
	FlushEvents(everyEvent, 0);
	/*  display menus for greeting window  */
	mh0 = NewMenu(128, "\p\x14");  /*  apple menu  */
	AppendMenu(mh0, "\pAbout Twirl ...(");
	AppendResMenu(mh0, 'DRVR');  /*  OS resource for Apple Menu Items Folder  */
	InsertMenu(mh0, 0);
	mh1 = NewMenu(129, "\pFile");
	AppendMenu(mh1, "\pNew/N");
	AppendMenu(mh1, "\pOpen");
	AppendMenu(mh1, "\pLog/L");
	AppendMenu(mh1, "\pSave(");
	AppendMenu(mh1, "\pSave As(");
	AppendMenu(mh1, "\pClose(/W");
	AppendMenu(mh1, "\pQuit/Q");
	InsertMenu(mh1, 0);
	DisableItem(mh1, 0);
	mh2 = NewMenu(130, "\pView");
	InsertMenuItem(mh2, "\pToggle Controls/T", 0);
	DrawMenuBar();
	/*  Show Greet Window  */
	if (!(greetWindow()))
		goto initexit;
	if (flags & F_LOG) {
		if (doWindowStat(TW_INIT))
			DisableItem(mh1, TMF_NEWLOG);
		}
	/*  initialize Random() seed already set to 1 by InitGraf()  */
	GetDateTime((unsigned long *) &qd.randSeed);
	if (flags & F_LOG) {
		if (statDoc.winPtrx)
			wprintf(&statDoc, "\nRandom() seed %d, wait for menus %d", LoWord(qd.randSeed), flags & F_WAIT);
		}
	/*  Initialize QD3D  */
	statusQD3D = Q3Initialize();
	if (statusQD3D == kQ3Failure) {
		errorMsg = "QD3D Initialization Failed";
		doWindowStat(TSW_ERRORMSG);
		SysBeep(1);
		waitForKey();
		goto initexit;
		}
	if (flags & F_LOG) {
		if (statDoc.winPtrx) wprintf(&statDoc, "\nQD3D Initialization successful");
		}
	initok = 1;
initexit:
    return(initok);
	}


void Cleanup() {
	doWindowStat(TW_CLOSE);
	}


/*  Event Loop  */
void MainEventLoop() {
	Str255 menuItemName;
	Boolean gQuitFlag = false;
	EventRecord event;
	WindowPtr whichWindow;
	short whichPart, menu, menuItem;
	struct docWindowBasic *doc;
	long menuEvent;
	Point aPoint = {100, 100};
	Rect rect;

	while (!gQuitFlag) {
//		for (menuItem = 0; menuItem < MAX3DVIEWS; menuItem++)
//			if (!(doWindowView(TW_NULL, menuItem)))
//				doWindowStat(TSW_ERRORMSG);
		if (WaitNextEvent(everyEvent, &event, 0, nil)) {
//		if (GetNextEvent(everyEvent, &event)) {
//			SystemTask();
			Microseconds(&microTicks);  /*  get current microseconds past boot  */
			switch (event.what) {
			  case mouseDown:
	  			/*  update whichWindow, whichPart ... either could be null  */
				whichPart = FindWindow(event.where, &whichWindow);
				switch (whichPart) {
				  case inMenuBar:
					menuEvent = MenuSelect(event.where);
					menu = HiWord(menuEvent);
					menuItem = LoWord(menuEvent);
					switch (menu) {
					  case 128:
						switch (menuItem) {
						  case TMA_ABOUT:
							if (!aboutWindow)
								if (doWindowAbout(TW_INIT)) {
									DisableItem(mh0, TMA_ABOUT);
									DisableItem(mh1, TMF_SAVE);
									DisableItem(mh1, TMF_SAVEAS);
									DisableItem(mh1, TMF_CLOSE);
									DrawMenuBar();
									}
							break;
						  default:
							GetMenuItemText(mh0, menuItem, menuItemName);
							OpenDeskAcc(menuItemName);
							}
					  	break;
					  case 129:
						switch (menuItem) {
						  case TMF_NEW:
donew:						if (doWindowView(TW_INIT, 0))  /*  NEW 3D WINDOW  */
								DrawMenuBar();
							else
								doWindowStat(TSW_ERRORMSG);
							break;
						  case TMF_OPEN:
doopen:						doWindowView(TW_OPEN, 0);
							doWindowStat(TSW_ERRORMSG);
							break;
						  case TMF_NEWLOG:
dolog:						doWindowStat(TW_INIT);
							DrawMenuBar();
							break;
						  case TMF_CLOSE:
doclose:					if (whichWindow = FrontWindow()) {
dogoaway:						doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
								switch (doc->type) {
								  case TV3D:
									doWindowView(TW_CLOSE, doc->id);
									break;
								  case TVLOG:
									doWindowStat(TW_CLOSE);
									break;
									}
								if (!((flags & F_LOG) || qtyOpen3D))
									DisableItem(mh1, TMF_CLOSE);
								whichWindow = FrontWindow();
								goto docmenustate;
								}
							break;
						  case TMF_SAVEAS:
							if (whichWindow = FrontWindow()) {
								doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
								switch (doc->type) {
								  case TV3D:
									if (!(doWindowView(TW_SAVEAS, doc->id)))
										doWindowStat(TSW_ERRORMSG);
									break;
									}
								DrawMenuBar();
								}
							break;
						  case TMF_SAVE:
							if (whichWindow = FrontWindow()) {
								doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
								switch (doc->type) {
								  case TV3D:
									if (!(doWindowView(TW_SAVE, doc->id)))
										doWindowStat(TSW_ERRORMSG);
									break;
									}
								DrawMenuBar();
								}
							break;
						  case TMF_QUIT:
doquit:						if (F_LOG & flags)
								if (statDoc.winPtrx) wprintf(&statDoc, "\nQuit %d", qtyOpen3D);
							/*  klunky but effective  */
							for (menuItem = 0; menuItem < MAX3DVIEWS; menuItem++)
								doWindowView(TW_CLOSE, menuItem);
							gQuitFlag = true;
							}  /*  switch  */
						break;
					  case 130:
						switch (menuItem) {
						  case TMV_TOGGLECTRLS:
							if (whichWindow = FrontWindow()) {
								doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;
								if (doc->type == TV3D) {
									if (!(doWindowView(TW_TOGGLECTRLS, doc->id)))
										doWindowStat(TSW_ERRORMSG);
									}
								}
							}  /*  switch  */
						}  /*  switch (menu)  */
					HiliteMenu(0);
					break;
				  case inDrag:
					rect = (**GetGrayRgn()).rgnBBox;
					DragWindow(whichWindow, event.where, &rect);
docmenustate:		if (whichWindow) {
						doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
						if (flags & F_LOG)
							if (statDoc.winPtrx) wprintf(&statDoc, "\nWindow flags %x", doc->flags);
						switch (doc->type) {
						  case TV3D:
							InsertMenu(mh2, 0);  /*  make view menu visable  */
							/*  usually don't want to close or save while xfering  */
							if (doc->flags & TVF_XFERING)
								goto docmenustateabout;
							else {
								EnableItem(mh1, TMF_SAVEAS);
								EnableItem(mh1, TMF_CLOSE);
								if (doc->flags & TVF_DIRTY)
									EnableItem(mh1, TMF_SAVE);
								else
									DisableItem(mh1, TMF_SAVE);
								}
							if (qtyOpen3D >= MAX3DVIEWS)
								DisableItem(mh1, TMF_NEW);
							break;
						  case TVLOG:
							DeleteMenu(130);  /*  hide view menu  */
							DisableItem(mh1, TMF_SAVE);
							DisableItem(mh1, TMF_SAVEAS);
							EnableItem(mh1, TMF_CLOSE);
							if (qtyOpen3D >= MAX3DVIEWS)
								DisableItem(mh1, TMF_NEW);
							break;
						  default:  //  about box ...
							DeleteMenu(130);
docmenustateabout:			DisableItem(mh1, TMF_SAVE);
							DisableItem(mh1, TMF_SAVEAS);
							DisableItem(mh1, TMF_CLOSE);
							if (qtyOpen3D >= MAX3DVIEWS)
								DisableItem(mh1, TMF_NEW);
							}
						}
					else {  /*  menu state when no windows open  */
						EnableItem(mh1, TMF_NEW);
						EnableItem(mh1, TMF_OPEN);
						EnableItem(mh1, TMF_NEWLOG);
						DisableItem(mh1, TMF_SAVEAS);
						DisableItem(mh1, TMF_SAVE);
						DisableItem(mh1, TMF_CLOSE);
						DeleteMenu(130);
						}
					if (whichPart == inMenuBar)
						HiliteMenu(0);
					DrawMenuBar();
					break;
				  case inContent:
					if (whichWindow != FrontWindow()) {
						SelectWindow(whichWindow);
						goto docmenustate;
						}
					doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
					doc->event = event;
					switch (doc->type) {
					  case TVABOUT:
						doWindowAbout(TW_CONTENT);
						break;
					  case TV3D:
						doWindowView(TW_CONTENT, doc->id);
						}
					break;
				  case inGoAway:
					if (TrackGoAway(whichWindow, event.where))
						goto dogoaway;
					break;
				  case inGrow:
					doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
					doc->event = event;
					switch (doc->type) {
					  case TV3D:
						doWindowView(TW_GROW, doc->id);
						break;
					  case TVLOG:
						doWindowStat(TW_GROW);
						break;
						}
					break;
					}
			  	break;
			  case updateEvt:
				if (whichWindow = (WindowPtr) event.message) {
					BeginUpdate(whichWindow);
					doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
					if (doc->type == TV3D)
						doWindowView(TW_UPDATE, doc->id);
					else if (doc->type == TVABOUT)
						doWindowAbout(TW_UPDATE);
					EndUpdate(whichWindow);
					}
				break;
			  case keyDown:
			  case autoKey:
				if (event.modifiers & 0x0100) {  /*  character code  */
					switch (event.message & 0xFF) {  /*  Command modifier code  */
					  case 'q':
						goto doquit;
					  case 'n':
						goto donew;
					  case 'w':
						goto doclose;
					  case 'l':
						if (!(flags & F_LOG))
							goto dolog;
						break;
					  case 'o':
						goto doopen;
						}
					}
				if (whichWindow = FrontWindow()) {
					doc = (struct docWindowBasic *) ((WindowRecord *) whichWindow)->refCon;    /*  GetWRefCon() replacement  */
					doc->event = event;
					switch (doc->type) {
					  case TV3D:
						doWindowView(TW_KEYBOARD, doc->id);
						break;
					  case TVABOUT:
						doWindowAbout(TW_KEYBOARD);
						if (!aboutWindow) {
							whichWindow = FrontWindow();
							goto docmenustate;
							}
						break;
					  case TVLOG:
						doWindowStat(TW_KEYBOARD);
						break;
						}
					}
				break;
			  case diskEvt:
				if (HiWord(event.message) != noErr) 
					(void) DIBadMount(aPoint, event.message);
				break;
			  case osEvt:
			  case activateEvt:
				break;
				}
			}
		/*  perform null event activity  */
		else
			for (menuItem = 0; menuItem < MAX3DVIEWS; menuItem++)
				if (!(doWindowView(TW_NULL, menuItem)))
					doWindowStat(TSW_ERRORMSG);
		}  /*  while  */
	}


#define AW 160
#define AH  64
#define BW  60    /*  button width  */
#define BH  20    /*  button height  */

doWindowAbout(int method) {
	Rect aboutBounds;            /*   top       left  bottom         right  */
	static Rect buttonBounds = {    AH-BH, (AW-BW)/2,     AH, (AW-BW)/2+BW };
	short controlPart;
	static struct docWindowBasic doc;
	static ControlHandle buttonHdl;
	ControlHandle control;
	GDHandle gfxDevHdl0;
	short success = 0;

	switch (method) {
	  case TW_INIT:
	  	doc.type = TVABOUT;
		gfxDevHdl0 = GetMainDevice();
		aboutBounds.top = ((*gfxDevHdl0)->gdRect.bottom - AH) >> 1;
		aboutBounds.bottom = aboutBounds.top + AH;
		aboutBounds.left = ((*gfxDevHdl0)->gdRect.right - AW) >> 1;
		aboutBounds.right = aboutBounds.left + AW;
		if (!(aboutWindow = NewCWindow(nil, &aboutBounds, "\ptwirl", true,
		  movableDBoxProc, (WindowPtr) - 1, 0, (long) &doc)))
			goto bonk;
		buttonHdl = NewControl(aboutWindow, &buttonBounds, "\pOK",
		  true, 0, 0, 1, pushButProc, 0);
		if (!(buttonHdl)) {
bonk:		SysBeep(1);
			goto close0;
			}
		success = 1;
		break;
	  case TW_UPDATE:
		DrawControls(aboutWindow);
		SetPort(aboutWindow);
		About(AW);
		MoveTo((AW -  TextWidth(version, 0, sizeof (version))) >> 1, 40);
		DrawText(version, 0, sizeof (version));
		break;
	  case TW_CONTENT:
		SetPort(aboutWindow);
		GlobalToLocal(&doc.event.where);  /*  SetPort() must precede this?  */
		controlPart = FindControl(doc.event.where, aboutWindow, &control);
		if (control == buttonHdl) {
			if (TrackControl(control, doc.event.where, 0)) {
				if (flags & F_LOG) {
					if (statDoc.winPtrx) wprintf(&statDoc, "\nabout ok: %d,%d",
					  doc.event.where.h, doc.event.where.v);
					}
				goto close;
				}
			}
		break;
	  case TW_KEYBOARD:
		switch (doc.event.message & 0xFF) {
		  case 27:  /*  esc  */
		  case 13:  /*  return  */
		  	if (flags & F_LOG) {
				if (statDoc.winPtrx) wprintf(&statDoc, "\nabout ok");
				}
			goto close;
			}
		break;
	  case TW_CLOSE:
close:	EnableItem(mh0, TMA_ABOUT);
		DrawMenuBar();
close0:	if (aboutWindow) {
			DisposeWindow(aboutWindow);
			aboutWindow = 0;
			}
		}
	return (success);
	}


doWindowStat(int method) {
	static struct docWindowStatus doc;
	static Rect statBounds = { 0 };
	static Rect statLimits = { 68, 256, 32000, 32000};
	long growSize;
	short success = 0;

	switch (method) {
	  case TW_INIT:
	  	doc.type = TVLOG;
		if (!(statBounds.top & statBounds.bottom)) {
			statBounds.top = 48;  statBounds.bottom = statBounds.top + 96;
			statBounds.left = 16;  statBounds.right = statBounds.left + 256;
			}
		statDoc.winPtrx = NewCWindow(nil, &statBounds, "\pstatus log", true,
		  documentProc, (WindowPtr) - 1, true, (long) &doc);
		if (!statDoc.winPtrx) {
			SysBeep(1);
			goto close;
			}
		doc.wprintDocPtr = &statDoc;
		statDoc.textSize = 10;  /*  Set default font size for logging window  */
		SetPort(statDoc.winPtrx);
		TextSize(statDoc.textSize);
		if (statDoc.winPtrx) wprintf(&statDoc, "\nLogging ...");
		DisableItem(mh1, TMF_NEWLOG);
		DisableItem(mh1, TMF_SAVEAS);
		DisableItem(mh1, TMF_SAVE);
		EnableItem(mh1, TMF_CLOSE);
		flags |= F_LOG;
		success = 1;
		break;
	  case TW_GROW:
		/*  can window limits and other window contextual bits, be
		/*  attached to a custom windows data structure  */
		growSize = GrowWindow(statDoc.winPtrx, doc.event.where, &statLimits);
		if (statDoc.winPtrx) wprintf(&statDoc, "\nGrow Window %d,%d", LoWord(growSize), HiWord(growSize));
		if (growSize)
			SizeWindow(statDoc.winPtrx, LoWord(growSize), HiWord(growSize), 1);
		/*  probably need to update window contents here  */
		break;
	  case TW_KEYBOARD:
		if (doc.event.modifiers & 0x0100) {
			switch (doc.event.message & 0xFF) {
			  case 'h':
				goto showmem;
				}
			}
		break;
	  case TSW_REPORTMEM:
showmem:if (flags & F_LOG)
			if (statDoc.winPtrx)
				wprintf(&statDoc, "\nMemory: S%lx, B%lx, F%lx\nsecs: %lx:%lx",
				  StackSpace(), MaxBlock(), FreeMem(), microTicks.hi, microTicks.lo);
		break;
	  case TSW_ERRORMSG:
	  	if (flags & F_LOG)
			if (statDoc.winPtrx)
				if (errorMsg) {
					wprintf(&statDoc, "\n%s", errorMsg);
					errorMsg = 0;
					}
		break;
	  case TW_CLOSE:
		flags &= ~F_LOG;
close:	if (statDoc.winPtrx) {
			DisposeWindow(statDoc.winPtrx);
			statDoc.winPtrx = 0;
			EnableItem(mh1, TMF_NEWLOG);
			}
		}
	return (success);
	}


#define GW 160
#define GH  96

int greetWindow(void) {
	Rect greetBounds;            /*    top      left    bottom   right  */
	static Rect delayBounds =  { GH-BH-2-BH-2-BH,       2,  GH-BH-2-BH-2,  2+160};
	static Rect checkBounds =  { GH-BH-2-BH,       2,  GH-BH-2,  2+160};
	static Rect buttonBounds = {      GH-BH, GW-2-BW,       GH,   GW-2};
	static Rect cancelBounds = {      GH-BH,       2,       GH,   2+BW};
	WindowPtr greetWindow, window;
	short windowPart, controlPart;
	Str255 menuItemName;
	ControlHandle control, buttonHdl, checkHdl, cancelHdl, delayHdl;
	GDHandle gfxDevHdl0;
	Boolean gQuitFlag = false;
	EventRecord event;
	Rect rect;
	short menu, menuItem;
	long menuEvent;
	Point mouse;
	int returnval = 1;

	gfxDevHdl0 = GetMainDevice();
	greetBounds.top = ((*gfxDevHdl0)->gdRect.bottom - GH) >> 1;
	greetBounds.bottom = greetBounds.top + GH;
	greetBounds.left = ((*gfxDevHdl0)->gdRect.right - GW) >> 1;
	greetBounds.right = greetBounds.left + GW;
	if (!(greetWindow = NewCWindow(nil, &greetBounds, "\ptwirl", true,
	  movableDBoxProc, (WindowPtr) - 1, 0, 0)))
		goto bonk;
	checkHdl = NewControl(greetWindow, &checkBounds, "\pStatus Log",
	  true, (flags & 2) >> 1, 0, 1, checkBoxProc, 0);
	delayHdl = NewControl(greetWindow, &delayBounds, "\pWait for Menu",
	  true, flags & 1, 0, 1, checkBoxProc, 0);
	cancelHdl = NewControl(greetWindow, &cancelBounds, "\pexit",
	  true, 0, 0, 1, pushButProc, 0);
	buttonHdl = NewControl(greetWindow, &buttonBounds, "\ptwirl",
	  true, 0, 0, 1, pushButProc, 0);
	if (!(checkHdl && cancelHdl && buttonHdl && delayHdl)) {
bonk:	SysBeep(1);
		goto exit;
		}
	while (!gQuitFlag) {
		if (WaitNextEvent(everyEvent, &event, 0, nil)) {
			switch (event.what) {
			  case updateEvt:
				if (window = (WindowPtr) event.message) {
					BeginUpdate(window);
					if (window == greetWindow) {
						DrawControls(greetWindow);
						SetPort(greetWindow);
						About(GW);
						}
					EndUpdate(window);
					}
				break;
			  case mouseDown:
			  	windowPart = FindWindow(event.where, &window);
				switch (windowPart) {
				  case inDrag:
					rect = (**GetGrayRgn()).rgnBBox;
					DragWindow(window, event.where, &rect);
					break;
				  case inMenuBar:
					menuEvent = MenuSelect(event.where);
					menu = HiWord(menuEvent);
					menuItem = LoWord(menuEvent);
					switch (menu) {
					  case 128:
						switch (menuItem) {
						  case 1:
							SysBeep(1);
							break;
						  default:
							GetMenuItemText(mh0, menuItem, menuItemName);
							OpenDeskAcc(menuItemName);
							}
						}
					HiliteMenu(0);
					break;
				  case inContent:
					SetPort(window);
					mouse = event.where;
					GlobalToLocal(&mouse);
					controlPart = FindControl(mouse, window, &control);
					if (control == checkHdl) {
						if (TrackControl(control, mouse, 0)) {
							if (GetControlValue(control))
								flags &= ~F_LOG;
							else
								flags |= F_LOG;
							SetControlValue(control, (flags & F_LOG) / F_LOG);
							}
						}
					else if (control == delayHdl) {
						if (TrackControl(control, mouse, 0)) {
							if (GetControlValue(control))
								flags &= ~F_WAIT;
							else
								flags |= F_WAIT;
							SetControlValue(control, flags & F_WAIT);
							}
						}
					else if (control == buttonHdl) {
						if (TrackControl(control, mouse, 0)) {
							returnval = 1;
							goto quitwin;
							}
						}
					else if (control == cancelHdl) {
						if (TrackControl(control, mouse, 0)) {
							returnval = 0;
							goto quitwin;
							}
						}
					break;
					}
				break;
			  case keyDown:
			  case autoKey:
				switch (event.message & 0xFF) {
				  case 27:  /*  esc  */
					returnval = 0;
					goto quitwin;
				  case 13:  /*  return  */
					returnval = 1;
quitwin:			gQuitFlag = true;
					break;
					}
				}
			}
		}  /*  while  */
exit:
	if (greetWindow)
		DisposeWindow(greetWindow);
	return (returnval);
	}


/*  Wait for Keyboard or Mouse activity  */
/*  This should probably be rewritten to use a dialog box  */
void waitForKey() {
	WindowPtr whichWindow;
	Boolean gQuitFlag = false;
	EventRecord event;
	Rect rect;
	short whichPart;

	while (!gQuitFlag) {
		if (WaitNextEvent(everyEvent, &event, 0, nil)) {
			switch (event.what) {
			  case updateEvt:
				if (whichWindow = (WindowPtr) event.message) {
					BeginUpdate(whichWindow);
					EndUpdate(whichWindow);
					}
				break;
			  case mouseDown:
			  	whichPart = FindWindow(event.where, &whichWindow);
				if (whichPart == inDrag) {
					rect = (**GetGrayRgn()).rgnBBox;
					DragWindow(whichWindow, event.where, &rect);
					}
				break;
			  case keyDown:
			  case autoKey:
				gQuitFlag = true;
				}
			}
		}
	}


void About(int w) {

	TextSize(12);
	MoveTo((w - TextWidth(aboutText, ZAPTECHCOPYSTL)) >> 1, 12);
	DrawText(aboutText, ZAPTECHCOPYSTL);
	TextSize(10);
	MoveTo((w - TextWidth(aboutText, ZAPTECHURLSTL)) >> 1, 26);
	DrawText(aboutText, ZAPTECHURLSTL);
	}
