/*	zap technologies - copyright 1998
/*	http://www.zaptech.com
/*
/*  created
/*  1999-04-04 - forked from models.c
*/


/*  constants  */
#define CHARSPERPASS_DEFAULT 1024
#define FILEBUFREC_PARSEBUFSIZE 96

enum {  /*  twirl flag bits  */
	TF_SHOWCTRLS = 1,
	TF_VPCTRLS =   2   /*  when set control handles must be valid!  */
	};

enum {  /*  view flag bits  */
	TVF_DIRTY  =    1,
	TVF_XFERING =   2,  /*  usually don't want to close or
	                        save while xfering  */
	TVF_REFLINES =  4,
	TVF_NULLON =    8,  /*  set at INIT or OPEN  */
	TVF_OPENING =  16,  /*  set while open processing  */
	TVF_AUTOSPIN = 32   /*  you know, that damn auto spinning twirl thing  */
	};

enum {  /*  file states  */
	TVFS_VOID = 0,
	TVFS_OPENREAD,
	TVFS_READHEAD,
	TVFS_CLOSE
	};

//  Node
//    Node
//    Node DEF xxxx
//    USE xxxx
//  field
//    single field value
//    { 1st field value 2nd field value ... }
//  value
//    xxxx
enum {  /*  fileBufRec parse states  */
	TVFSOP_NODEPRE = 0,
	TVFSOP_NODE,
	TVFSOP_NODEPOST,
	TVFSOP_NODEDEFPRE,
	TVFSOP_NODEDEF,
	TVFSOP_NODEUSEPRE,
	TVFSOP_NODEUSE,
	TVFSOP_NODEROUTEPR,
	TVFSOP_NODEROUTEPRE,
	TVFSOP_NODEROUTESRC,
	TVFSOP_NODEROUTESRCFIELD,
	TVFSOP_NODEROUTETO,
	TVFSOP_NODEROUTEPRE2,
	TVFSOP_NODEROUTEDEST,
	TVFSOP_NODEROUTEDESTFIELD,
	TVFSOP_NODEIGNORE,
	TVFSOP_FIELDPRE,
	TVFSOP_FIELD,
	TVFSOP_FIELDIGNORE_PRE,
	TVFSOP_FIELDIGNORE_USE,
	TVFSOP_FIELDIGNORE_USEPOST,
	TVFSOP_FIELDIGNORE_DEF,
	TVFSOP_FIELDIGNORE_DEFINE,
	TVFSOP_FIELDIGNORE_DEFNODE,
	TVFSOP_FIELDIGNORE_DEFPOST,
	TVFSOP_FIELDIGNORE_NODE,
	TVFSOP_FIELDIGNORE_FIELD,
	TVFSOP_FIELDIGNORE_OTHER,
	TVFSOP_FIELDIGNORE_ARRAY,
	TVFSOP_FIELDIGNORE_STRING,
	TVFSOP_MFVEC3FPRE,
	TVFSOP_MFVEC3F_NOMEM,
	TVFSOP_MFVEC3F,
	TVFSOP_MFFLOATPRE,
	TVFSOP_MFFLOAT_NOMEM,
	TVFSOP_MFFLOAT,
	TVFSOP_FLOATPRE,
	TVFSOP_FLOATNEGPRE,
	TVFSOP_FLOAT,
	TVFSOP_MFINT32PRE,
	TVFSOP_MFINT32_NOMEM,
	TVFSOP_MFINT32,
	TVFSOP_INT32PRE,
	TVFSOP_INT32,
	TVFSOP_STRINGPRE,
	TVFSOP_STRING,
	TVFSOP_BOOL0,
	TVFSOP_BOOL1,
	TVFSOP_BOOL2
	};

enum {  /*  fileBufRec flags bits  */
	TO_COMMENT =       1,
    /*  note, the following three values are parsed exclusive of each other  */
	TO_VALUEINTNEG =   2,
	TO_VALUEPOSTDEC =  2,
	TO_STARTCHAR =     2,  /*  currently used to signal that node name and { just read  */
	TO_VALUEMFVEC3F =  4,
	TO_VALUEMFFLOAT =  8,
	TO_VALUEMFINT320 = 16
	};


/*  data structures  */
struct fileBufRecRoute {
	char *s[4];
	char c;
	};

struct fileBufRecValues {
	Handle multiArgBufHdl; /*  when allocated used as a scratch area to
   		                       parse arbitrary length array values into  */
	long multiArgBufi;     /*  element index, incremented as values are stored  */
	long multiArgBufnmax;  /*  */
	float fdec;
	double df;
	long int32;
	};

struct fileBufRec0 {
	/*  !!! make sure all feilds in this structure are initialized to sane values
	/*  at fileState TVFS_OPENREAD !!!  Consider moving allocation of
	/*  this into TVFS_OPENREAD code section  */
	char flags;
	char parseState;
	char argi;  /*  field can have multiple arguments/values  */
	char bufi;
	struct VN_NodeLink *nodeLinkCurrent;
	char *define;
	union {
		struct fileBufRecValues v;
		struct fileBufRecRoute r;
		char buf[FILEBUFREC_PARSEBUFSIZE];
//		char buf[96];
		};
	};

struct twirlRec {
	Rect pane0;
	unsigned short flags;
	ControlHandle viewPrevButtonHdl;
	ControlHandle viewNextButtonHdl;
	TQ3ViewObject view;
	TQ3ViewObject shader;
	struct OpaqueTQ3Object *model;
	TQ3StyleObject interpolation;
	TQ3StyleObject backFacing;
	TQ3StyleObject fillStyle;
	TQ3Matrix4x4 rotation;
	float rx, ry, rz;
	float px, py, pz;       /*  position  */
	float ox, oy, oz, or;   /*  orientation  */
	float ax, ay, az;       /*  ahead vector  */
	};

struct docWindowView {
	char type;				/*  required  */
	char id;				/*  required  */
	unsigned short flags;	/*  required  */
	EventRecord event;		/*  required  */
	WindowPtr winPtr;
	short navigationMode;
	FSSpec fileSpec;
	short fileRN;
	short fileState;
	struct fileBufRec0 *fileBufRec;
	struct twirlRec twirl;
	struct VN_NodeLink *vrml;
	};


/*  function prototypes  */
#ifdef H_PARSE_PROTOS
enum {  /*  moveCamera() methods  */
	TVC_LOG = 0,
	TVC_APPROACH,
	TVC_PULLBACK,
	TVC_SET,
	TVC_PANE
	};

enum {  /*  twirl() methods  */
	TWIRL_VIEWNEW = 0,
	TWIRL_DRAW,
	TWIRL_DISPOSE
	};

Init3dView(struct docWindowView *doc);
Open3dView(struct docWindowView *doc);
Save3dView(struct docWindowView *doc);
Twirl(struct docWindowView *doc, short method);
moveCamera(struct twirlRec *twirl, short method);
#endif
