/*  win32shell.c  */

#include <windows.h>
#include "myio.h"


DWORD WINAPI engine_thread (LPVOID lpParam);
void output_text(char * text, int newline);

#define ID_COMMANDLINE 	1
#define ID_DEBUGTEXT 	2

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CommandLineEditProc (HWND, UINT, WPARAM, LPARAM) ;//for the enter field
LRESULT CALLBACK DebugTextEditProc (HWND, UINT, WPARAM, LPARAM) ;//for the enter field

WNDPROC oldCommandLineEditProc;


HWND hwndCommandLine ;
HWND hwndDebugText;


char outputtextbuffer[65000];

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
					PSTR szCmdLine, int iCmdShow) {
	static TCHAR szAppName[] =TEXT("Hello Win");
	HWND		hwnd;
	MSG 		msg;
	WNDCLASS	wndclass;

	wndclass.style				= CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc		= WndProc;
	wndclass.cbClsExtra 		= 0;
	wndclass.cbWndExtra 		= 0;
	wndclass.hInstance			= hInstance;
	wndclass.hIcon				= LoadIcon (NULL,IDI_APPLICATION);
	wndclass.hCursor			= LoadCursor (NULL, IDC_ARROW);
	wndclass.hbrBackground		= (HBRUSH) GetStockObject (WHITE_BRUSH);
	wndclass.lpszMenuName		= NULL;
	wndclass.lpszClassName		= szAppName;
	
	if(!RegisterClass (&wndclass)) {
		MessageBox (NULL, TEXT("This program requires winNT"),szAppName, MB_ICONERROR);
		return 0;
		}
	
	hwnd = CreateWindow (szAppName,
		TEXT("Engine"),
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);
	ShowWindow (hwnd, iCmdShow);
	UpdateWindow(hwnd);
	
	while(GetMessage (&msg, NULL, 0,0)) {
		TranslateMessage (&msg);
		DispatchMessage(&msg);
		}
	return (msg.wParam);
	}


LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {	
	static HANDLE hThread;
	DWORD oldThread;

	switch (message) {
	  case WM_CREATE:
		//create the command line
		hwndCommandLine = CreateWindow (TEXT ("edit"), NULL,
			WS_CHILD | WS_VISIBLE |
			WS_BORDER | ES_LEFT	|
			ES_AUTOHSCROLL | WS_BORDER,
			0, 0, 0, 0, hwnd, (HMENU) ID_COMMANDLINE,
			((LPCREATESTRUCT) lParam) -> hInstance, NULL) ;
		
		//set the call back routine for the edit field and save the old one
		oldCommandLineEditProc = (WNDPROC) SetWindowLong (hwndCommandLine, GWL_WNDPROC, (LONG) CommandLineEditProc) ;

		//create the debug text
		hwndDebugText = CreateWindow (TEXT ("edit"), NULL,
			WS_CHILD | WS_VISIBLE |
			WS_BORDER | ES_LEFT	|
			ES_AUTOHSCROLL | WS_BORDER |
			ES_MULTILINE | ES_AUTOVSCROLL | WS_VSCROLL ,
			0, 0, 0, 0, hwnd, (HMENU) ID_DEBUGTEXT,
			((LPCREATESTRUCT) lParam) -> hInstance, NULL) ;

		//show opening message
		myprintf("welcome to myprintf()\n");
		
		//start thread for engine
		hThread = CreateThread(NULL, 0, engine_thread, 0, 0, &oldThread);
		/*  fall through  */

	  case WM_SETFOCUS :
		SetFocus(hwndCommandLine) ;
		return (0) ;

	  case WM_SIZE : 
		//set edit field to be bottom of screen
		MoveWindow (hwndCommandLine, 0, HIWORD(lParam) - 20, LOWORD(lParam), 20, TRUE) ;
		
		//set debug text field to top of screen
		MoveWindow (hwndDebugText, 0,  0, LOWORD(lParam), HIWORD(lParam) - 20, TRUE) ;
		return (0);

	  case WM_COMMAND :
		if (LOWORD (wParam) == ID_COMMANDLINE)
			if (HIWORD (wParam) == EN_ERRSPACE || HIWORD (wParam) == EN_MAXTEXT)
			  MessageBox (hwnd, TEXT ("Edit control out of space."),
			  "stuff", MB_OK | MB_ICONSTOP);
		return (0);

	  case WM_DESTROY:
		PostQuitMessage(0);
		return (0);
		}
	return(DefWindowProc(hwnd, message, wParam, lParam));
	}


LRESULT CALLBACK CommandLineEditProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {
	int id;
	char command[1024];

	id = GetWindowLong(hwnd, GWL_ID) ;
	switch (message) {
	  case WM_KEYDOWN :
		if (wParam == VK_RETURN) {
			//show command in debug window
			GetWindowText(hwnd,command,1000);
			myprintf(command);  /*  echo command in debug area  */
			//parse and do the command
			//commandline_docommand(command);	//now try the command
			//clear text
			SetWindowText(hwnd,"");
			}			
		break ;
		}
	//exec the old proc for the edit field so normal edit stuff happens
	return CallWindowProc(oldCommandLineEditProc, hwnd, message, wParam, lParam) ;
	}


DWORD WINAPI engine_thread(LPVOID lpParam) {
	short i;

	for (i = 0; i < 10; i++)
		myprintf("test\n");
	return (0);
	}