/*  Win32 ZETUP.EXE meta installer  */
/*  Frederick Shaul  */
/*  copyright zap technologies  */
/*  updated October 8, 1998  */

/* headers  */
#include <windows.h>
#include "zetup.h"


/*  globals  */
struct Panel Panels[MAXPANELS] = { 0 };
char szAppName[] = "ZETUP";
char szSubWin[] = "SubWin";
char greet[64] = "nothing yet ...";
int currentPanel;
int nextPanel;
HDC hdcMem;
POINT ptSize, ptOrg;


/*  prototypes  */
HWND CreatePanel(struct Panel *panel, HINSTANCE hInstance);
long CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
void ProcessIniFile(char *inifile);
void ParseIniFile(char mode, struct IniFileTokenValue *tv);
void LoadBackdropFile(struct Panel *panel);


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  PSTR szCmdLine, int iCmdShow) {
    MSG msg;
    WNDCLASS wndclass;
	int i;

    /*  random random seed  */
    srand(GetTickCount());

	/*  create a 'class' for basic window settings  */
    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = WndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
    wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH) GetStockObject (BLACK_BRUSH);
    wndclass.lpszMenuName  = 0;
    wndclass.lpszClassName = szAppName;
    RegisterClass(&wndclass);
	/*  process initialization file  */
	nextPanel = currentPanel = -1;  /*  no panels valid at this time  */
    ProcessIniFile(INITFILE);
	currentPanel = 0;  /*  usually the main panel start panel  */
    if (Panels[currentPanel].wndHdl = CreatePanel(&Panels[currentPanel], hInstance)) {
        /*  make window visible  */
        ShowWindow(Panels[currentPanel].wndHdl, iCmdShow);
        UpdateWindow(Panels[currentPanel].wndHdl);
	    /*  loop until QuitMessage  */
        while (GetMessage(&msg, NULL, 0, 0)) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
			if (nextPanel >= 0) {
    			DestroyPanel(currentPanel);
				currentPanel = nextPanel;
				nextPanel = -1;
				if (Panels[currentPanel].wndHdl = CreatePanel(&Panels[currentPanel], hInstance)) {
                    ShowWindow(Panels[currentPanel].wndHdl, iCmdShow);
                    UpdateWindow(Panels[currentPanel].wndHdl);
					}
				else
				    goto bye;
			    }
            }
        return (msg.wParam);
		}
    else
bye:    return(0);
    }


HWND CreatePanel(struct Panel *panel, HINSTANCE instanceHdl) {
    HWND hwnd = 0;
	int w, h;

    /*  Create main window ...
        class name, caption, style, x, y pos, x, y size,
        parent, menu, instance, flags  */
    if ((panel->backmapHdl == 0) && (panel->backdrop[0])) {
        LoadBackdropFile(panel);
        if (panel->backmapHdl == 0)
    	    goto bye;
	    }
    if (panel->backmapHdl) {
        w = panel->backmapInfoHeader.biWidth + 8;
        h = panel->backmapInfoHeader.biHeight + 27;
		}
    else {
        w = defaultwinwidth + 8;
        h = defaultwinheight + 27;
	    }
    hwnd = CreateWindow (szAppName, "ZETUP",
      WS_OVERLAPPED | WS_THICKFRAME | WS_SYSMENU,
      (GetSystemMetrics(SM_CXSCREEN) - w) >> 1,
      (GetSystemMetrics(SM_CYSCREEN) - h) >> 1,
      w, h, 0, 0, instanceHdl, 0);
bye:
    return (hwnd);
    }


DestroyPanel(int panel) {

    /*  delete backdrop device independent bitmap, and bitmap info  */
    GlobalFree(Panels[panel].backmapHdl);
    GlobalFree(Panels[panel].backmapInfoHdl);
    Panels[panel].backmapHdl = 0;
    Panels[panel].backmapInfoHdl = 0;
    /*  Delete device context used for backdrop bitmap  */
    DeleteDC(Panels[panel].dcHdl);
    Panels[panel].dcHdl = 0;
    /*  Delete device dependent backdrop bitmap  */
	DeleteObject(Panels[panel].ddBackmapHdl);
	Panels[panel].ddBackmapHdl = 0;
    /*  Delete window  */
    DestroyWindow(Panels[panel].wndHdl);  /*  cause WM_DESTROY message to be sent  */
	Panels[panel].wndHdl = 0;
    }


long CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {
    HDC hdc;
    BITMAPINFO *mapInfo;
    void *mapData;
    PAINTSTRUCT ps;
    RECT rect;
    int mx, my, i, j;
    static POINT xy[4];
    static int bflag = 0;

    switch(iMsg) {
      case WM_CREATE:
//		PlaySound ("hellowin.wav", NULL, SND_FILENAME | SND_ASYNC);
        hdc = GetDC(hwnd);
        if (Panels[currentPanel].backmapHdl) {
		    /*  create device dependent backdrop bitmap  */
            mapData = GlobalLock(Panels[currentPanel].backmapHdl);
            mapInfo = GlobalLock(Panels[currentPanel].backmapInfoHdl);
            Panels[currentPanel].ddBackmapHdl = CreateDIBitmap(hdc, &Panels[currentPanel].backmapInfoHeader,
              CBM_INIT, mapData, mapInfo, DIB_RGB_COLORS);
            GlobalUnlock(Panels[currentPanel].backmapInfoHdl);
            GlobalUnlock(Panels[currentPanel].backmapHdl);
            GetObject(Panels[currentPanel].ddBackmapHdl, sizeof (BITMAP), &(Panels[currentPanel].Backmap));
		    sprintf(greet, "%s size: %d, %d",
		      Panels[currentPanel].backdrop,
		      Panels[currentPanel].Backmap.bmWidth,
		      Panels[currentPanel].Backmap.bmHeight);
            /*  create new device context to use with backdrop bitmap */
            Panels[currentPanel].dcHdl = CreateCompatibleDC(hdc);
            SelectObject(Panels[currentPanel].dcHdl, Panels[currentPanel].ddBackmapHdl);
			/*  copy screen units from current window device context */
            SetMapMode(Panels[currentPanel].dcHdl, GetMapMode(hdc));
            }
        else
            MessageBeep(MB_OK);
        ReleaseDC(hwnd, hdc);
        return 0;
      case WM_PAINT:
        hdc = BeginPaint(hwnd, &ps);
		/*  redraw backdrop bitmap  */
        if (Panels[currentPanel].backmapHdl) {
            ptSize.x = Panels[currentPanel].Backmap.bmWidth;
            ptSize.y = Panels[currentPanel].Backmap.bmHeight;
            DPtoLP(hdc, &ptSize, 1);
            ptOrg.x = 0;
            ptOrg.y = 0;
            DPtoLP(hdc, &ptOrg, 1);
            BitBlt(hdc, 0, 0, ptSize.x, ptSize.y, Panels[currentPanel].dcHdl, ptOrg.x, ptOrg.y, SRCCOPY);
		    }
		/*  update dynamic text message  */
        //  GetClientRect(hwnd, &rect);
        if (Panels[currentPanel].flags & PANEL_STATMSG) {
            rect.left = 0;
            SetBkMode(hdc, TRANSPARENT);
            SetTextColor(hdc, RGB(0xFF, 0xFF, 0xFF));
            if (Panels[currentPanel].backmapHdl) {
                rect.top =    Panels[currentPanel].Backmap.bmHeight - 32;
                rect.right =  Panels[currentPanel].Backmap.bmWidth;
                rect.bottom = Panels[currentPanel].Backmap.bmHeight;
				}
            else {
                rect.top =    defaultwinheight - 32;
                rect.right =  defaultwinwidth;
                rect.bottom = defaultwinheight;
				}
            DrawText(hdc, greet, -1, &rect, DT_SINGLELINE | DT_BOTTOM);
			}
        if (Panels[currentPanel].flags & PANEL_HILITERECT) {
			if (bflag) {
    			SelectObject(hdc, GetStockObject(WHITE_PEN));
    			MoveToEx(hdc, xy[0].x, xy[0].y, 0);
	    		LineTo(hdc, xy[1].x, xy[1].y);
  	    		LineTo(hdc, xy[2].x, xy[2].y);
	    		LineTo(hdc, xy[3].x, xy[3].y);
	    		LineTo(hdc, xy[0].x, xy[0].y);
			    }
            }
        EndPaint(hwnd, &ps);
        return 0;
      case WM_MOUSEMOVE:
        if (Panels[currentPanel].flags & PANEL_HILITERECT) {
            mx = LOWORD(lParam);
            my = HIWORD(lParam);
            for (i = 0; i < MAXBUTTONS; i++) {
	    	    if ((Panels[currentPanel].button[i].flags & PF_BUTTONENABLED) &&
		          (mx >= Panels[currentPanel].button[i].x) &&
		          (mx < (Panels[currentPanel].button[i].x + Panels[currentPanel].button[i].w)) &&
		          (my >= Panels[currentPanel].button[i].y) &&
		          (my < (Panels[currentPanel].button[i].y + Panels[currentPanel].button[i].h)))
			        goto mm;
    			}
			if (bflag) {
			    bflag = 0;
			    goto mmi;
				}
			}
		goto mmexit;
mm:     bflag = 1;
        xy[0].x = Panels[currentPanel].button[i].x;
        xy[0].y = Panels[currentPanel].button[i].y;
        xy[1].x = xy[0].x + Panels[currentPanel].button[i].w;
        xy[1].y = xy[0].y;
        xy[2].x = xy[1].x;
        xy[2].y = xy[0].y + Panels[currentPanel].button[i].h;
        xy[3].x = xy[0].x;
        xy[3].y = xy[2].y;
        sprintf(greet, "move %d,%d-%d,%d", xy[0].x, xy[0].y, xy[1].x, xy[1].y);
mmi:    InvalidateRect(hwnd, 0, FALSE);
mmexit: return 0;
		break;
      case WM_LBUTTONUP:
        mx = LOWORD(lParam);
        my = HIWORD(lParam);
        sprintf(greet, "mouse up %d,%d", mx, my);
		if (Panels[currentPanel].backmapHdl)
            InvalidateRect(hwnd, 0, FALSE);
		else
            InvalidateRect(hwnd, 0, TRUE);  /*  erase background when no bitmap loaded  */
        for (i = 0; i < MAXBUTTONS; i++) {
		    if ((Panels[currentPanel].button[i].flags & PF_BUTTONENABLED) &&
		      (mx >= Panels[currentPanel].button[i].x) &&
		      (mx < (Panels[currentPanel].button[i].x + Panels[currentPanel].button[i].w)) &&
		      (my >= Panels[currentPanel].button[i].y) &&
		      (my < (Panels[currentPanel].button[i].y + Panels[currentPanel].button[i].h))) {
			    goto um;
				}
			}
bo:     return 0;
		break;
um:		/*  launch application  */
        if (Panels[currentPanel].button[i].flags & PF_LAUNCHEXECUTABLEINSTR)
            WinExec(Panels[currentPanel].button[i].command, SW_SHOWNORMAL);
		/*  launch HTML  */
		else if (Panels[currentPanel].button[i].flags & PF_LAUNCHHTMLFILE) {
            sprintf(greet, "START %s", Panels[currentPanel].button[i].command);
        //  MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
            WinExec(greet, SW_SHOWNORMAL);
	        }
		/*  switch panels  */
		else if (Panels[currentPanel].button[i].flags & PF_SWITCHPANEL) {
			for (j = 0; j < MAXPANELS; j++) {
			    if (strcmp(Panels[currentPanel].button[i].command, Panels[j].name) == 0) {
				    nextPanel = j;
				    }
			    }
			if (nextPanel == -1) {
                sprintf(greet, "Panel %s not found", Panels[currentPanel].button[i].command);
                MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
			    }
			}
		/*  no function  */
		else {
            sprintf(greet, "BUTTON %d = %d %s",
              i, Panels[currentPanel].button[i].value, Panels[currentPanel].button[i].command);
            MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
		    }
        //  WinExec("CALC", SW_SHOWNORMAL);
        //  WinExec("START INDEX.HTM", SW_SHOWNORMAL);
        //  WinExec("START www.zaptech.com", SW_SHOWNORMAL);
        goto bo;
	  case WM_GETMINMAXINFO:
        if (Panels[currentPanel].backmapHdl) {
    	    if ((i = Panels[currentPanel].Backmap.bmWidth) == 0)
			    i = Panels[currentPanel].backmapInfoHeader.biWidth;
		    ((MINMAXINFO *) lParam)->ptMaxSize.x =
		      ((MINMAXINFO *) lParam)->ptMinTrackSize.x =
    	      ((MINMAXINFO *) lParam)->ptMaxTrackSize.x = i + 8;
    	    if ((i = Panels[currentPanel].Backmap.bmHeight) == 0)
			    i = Panels[currentPanel].backmapInfoHeader.biHeight;
		    ((MINMAXINFO *) lParam)->ptMinTrackSize.y =
		      ((MINMAXINFO *) lParam)->ptMaxSize.y =
              ((MINMAXINFO *) lParam)->ptMaxTrackSize.y = i + 27;
		    }
        else {
		    ((MINMAXINFO *) lParam)->ptMaxSize.x =
		      ((MINMAXINFO *) lParam)->ptMinTrackSize.x =
		      ((MINMAXINFO *) lParam)->ptMaxTrackSize.x = defaultwinwidth + 8;
		    ((MINMAXINFO *) lParam)->ptMinTrackSize.y =
		      ((MINMAXINFO *) lParam)->ptMaxSize.y =
		      ((MINMAXINFO *) lParam)->ptMaxTrackSize.y = defaultwinheight + 27;
            }
		return 0;
      case WM_DESTROY:
	    if (nextPanel < 0)
            PostQuitMessage(0);
exit0:  return 0;
        }
    return DefWindowProc(hwnd, iMsg, wParam, lParam);
    }


/*
; this is a comment
[sectiona]
dxpath=
OEM=NO
[sectionb]
EnableDownload=TRUE
StateToolbarCreateTool="VCS",0x10f,0x0,64,0,0,0,0,200,300,"",1
*/

void ProcessIniFile(char *filename) {
    char value[80];
    char token[80];
    char section[80];
    HANDLE file;
    int i, c;
    int mode = LWS_NEWLINE;
	int valueindex;
	long l, lvalue;
    struct IniFileTokenValue tv;

    tv.section = section;
	tv.token = token;
    file = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ,
      0, OPEN_EXISTING, 0, 0);
    if (file == INVALID_HANDLE_VALUE) {
	    sprintf(value, "%s file not found", filename);
        ShowMessageBox(value);
		}
    else {
	    while (ReadFile(file, &c, 1, &l, 0) && l) {
		    switch (mode) {
			  case LWS_NEWLINE:
		        if (CHARPTR(c) == ';')
				    mode = LWS_COMMENT;
		        if (CHARPTR(c) == '[') {
				    /*  reset section and current panel  */
				    section[0] = 0;
                    currentPanel = -1;
				    mode = LWS_SECTIONPRE;
					}
		        else if ((section[0]) && (CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z')) {
			        i = 0;
  			        token[i++] = CHARPTR(c);
    	    	    mode = LWS_TOKEN;
					}
				break;
			  case LWS_SECTIONPRE:
		        if ((CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z')) {
				    i = 0;
				    section[i++] = CHARPTR(c);
				    mode = LWS_SECTION;
					}
		        else {
				    mode = LWS_COMMENT;
		            goto comment;
					}
				break;
			  case LWS_SECTION:
		        if ((CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z')) {
				    section[i++] = CHARPTR(c);
					}
		        else if (CHARPTR(c) == ']') {
				    section[i] = 0;
                //  sprintf(greet, "Section %s %d", section, currentPanel);
                //  MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
		            mode = LWS_COMMENT;
					}
				else {
				    mode = LWS_COMMENT;
		            goto comment;
					}
				break;
			  case LWS_TOKEN:
                if (CHARPTR(c) == '=') {
				    token[i] = 0;
				    mode = LWS_VALUEPRE;
					valueindex = 0;
					}
		        else if ((CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z'))
				    token[i++] = CHARPTR(c);
                else {
				    mode = LWS_COMMENT;
		            goto comment;
                    }
				break;
			  case LWS_VALUEPRE:
			    /*  this allows some white space to exist  */
                if ((CHARPTR(c) == 10) || (CHARPTR(c) == 13))
		            mode = LWS_NEWLINE;
		        else if ((CHARPTR(c) >= '0') && (CHARPTR(c) <= '9')) {
				    lvalue = CHARPTR(c) - '0';
					mode = LWS_VALUEINT;
					}
		        else if ((CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z')) {
				    lvalue = 0;
				    value[lvalue++] = CHARPTR(c);
					mode = LWS_VALUESTR;
					}
                break;
			  case LWS_VALUEINT:
		        if ((CHARPTR(c) >= '0') && (CHARPTR(c) <= '9'))
				    lvalue = CHARPTR(c) - '0' + lvalue * 10;
                else {
				    tv.value = (char *) &lvalue;
					tv.tokeni = valueindex;
                    ParseIniFile(IF_INT, &tv);
				    mode = LWS_VALUEPRE;
					valueindex++;
                    if ((CHARPTR(c) == 10) || (CHARPTR(c) == 13))
		                mode = LWS_NEWLINE;
		            else
					    mode = LWS_VALUEPRE;
					}
                break;
			  case LWS_VALUESTR:
		        if (((CHARPTR(c) >= 'A') && (CHARPTR(c) <= 'Z')) ||
		          ((CHARPTR(c) >= '0') && (CHARPTR(c) <= '9')) ||
		          (CHARPTR(c) == '.') || (CHARPTR(c) == '\\'))
				    value[lvalue++] = CHARPTR(c);
                else {
				    value[lvalue] = 0;
				    tv.value = value;
					tv.tokeni = valueindex;
                    ParseIniFile(IF_STR, &tv);
				    mode = LWS_VALUEPRE;
					valueindex++;
                    if ((CHARPTR(c) == 10) || (CHARPTR(c) == 13))
		                mode = LWS_NEWLINE;
		            else
					    mode = LWS_VALUEPRE;
					}
                break;
			  case LWS_COMMENT:
comment:        if ((CHARPTR(c) == 10) || (CHARPTR(c) == 13))
		            mode = LWS_NEWLINE;
				break;
				}  /*  switch(mode)  */
		    }  /*  while (ReadFile)  */
        CloseHandle(file);
        }
    }


void ParseIniFile(char mode, struct IniFileTokenValue *tv) {
    char msg[80];
	int i, b;

    if (currentPanel == -1) {
        if (strcmp(tv->section, "PANEL") == 0) {
            if (strcmp(tv->token, "PANELINFO") == 0) {
		        if (tv->tokeni == 0)
            	    if (mode == IF_INT) {
		                i = *((long *) tv->value);
						if ((i < 0) || (i >= MAXPANELS)) {
            	            sprintf(greet, INITFILE " error, Panel ID > %d", i);
                            MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
					        }
						else {
		                    currentPanel = *((long *) tv->value);
		                    Panels[currentPanel].flags = PANEL_STATMSG;
						    }
	                    }
			    }
			}
        }
    else if (strcmp(tv->section, "PANEL") == 0) {
        if (strcmp(tv->token, "PANELINFO") == 0) {
		    if (tv->tokeni == 1) {
           	    if (mode == IF_STR)
        		    strcpy(Panels[currentPanel].name, tv->value);
            //  sprintf(greet, "Panel Name %s %d", Panels[currentPanel].name, currentPanel);
            //  MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
				}
		    }
        else if (strcmp(tv->token, "STATMSG") == 0) {
		    if (mode == IF_INT) {
		        i = *((long *) tv->value);
//				if (i)
//				    Panels[currentPanel].flags |= PANEL_STATMSG;
//				else
//				    Panels[currentPanel].flags &= ~PANEL_STATMSG;
				Panels[currentPanel].flags = i;
				}
		    }
        if (strcmp(tv->token, "BACKDROP") == 0) {
		    if (mode == IF_STR)
		        strcpy(Panels[currentPanel].backdrop, tv->value);
		    }
        else if (strcmp(tv->token, "BUTTON") == 0) {
		    if (mode == IF_STR) {
			    b = Panels[currentPanel].currentButton;
		        strcpy(Panels[currentPanel].button[b].command, tv->value);
				}
		    else if (mode == IF_INT) {
		        i = *((long *) tv->value);
			    /*  make current button persistent until last value parsed  */
                if (tv->tokeni == 0) {
			        Panels[currentPanel].currentButton = i;
				    Panels[currentPanel].button[i].command[0] = 0;
					}
			    else {
				    b = Panels[currentPanel].currentButton;
			        switch (tv->tokeni - 1) {
				      case PB_X:
				        Panels[currentPanel].button[b].x = i;
				        break;
				      case PB_Y:
				        Panels[currentPanel].button[b].y = i;
				        break;
				      case PB_W:
				        Panels[currentPanel].button[b].w = i;
				        break;
				      case PB_H:
				        Panels[currentPanel].button[b].h = i;
				        break;
				      case PB_A:
				        Panels[currentPanel].button[b].flags =
				          Panels[currentPanel].button[b].value = i;
				        break;
				        }  /*  switch  */
				    }  /*  else  */
			    }  /*  if (IF_INT)  */
			}
	    }
    else {
        sprintf(msg, "[UNSUPPORTED]\n%s[%d]=%d",
          tv->section, tv->token, tv->tokeni, *((long *) tv->value));
        MessageBox(0, msg, szAppName, MB_OK | MB_TASKMODAL);
	    }
    }


void LoadBackdropFile(struct Panel *panel) {
    BITMAPFILEHEADER bitmapFileHeader;
	BITMAPINFO *bitmapInfo;
    void *map;
    HANDLE file;
    long l;

    if (panel->backmapHdl || panel->backmapInfoHdl)
        return;
    file = CreateFile(panel->backdrop, GENERIC_READ, FILE_SHARE_READ,
      0, OPEN_EXISTING, 0, 0);
    if (file == INVALID_HANDLE_VALUE)
bad:    sprintf(greet, "backdrop %s file not found", panel->backdrop);
    else {
	    /*  read file header  */
        if (!(ReadFile(file, &bitmapFileHeader,
          sizeof (BITMAPFILEHEADER), &l, 0)) || !l) {
            sprintf(greet, "backdrop %s file read error", panel->backdrop);
	        goto y;
			}
		/*  read bitmap info header  */
        if (!(ReadFile(file, &panel->backmapInfoHeader,
          sizeof (BITMAPINFOHEADER), &l, 0)) || !l) {
            sprintf(greet, "backdrop %s file read error", panel->backdrop);
            goto y;
			}
        /*  predict size of and allocate bitmap info  */
        if (panel->backmapInfoHeader.biBitCount > 8) {
            if (panel->backmapInfoHeader.biBitCount != 24) {
                sprintf(greet, "backdrop %s file unsupported bitdepth %d",
                  panel->backdrop, panel->backmapInfoHeader.biBitCount);
                goto y;
				}
            if (!(panel->backmapInfoHdl = GlobalAlloc(GHND, sizeof (BITMAPINFOHEADER)) )) {
                sprintf(greet, "backdrop %s file backmapInfoHdl GlobalAlloc failure",
                  panel->backdrop);
                goto y;
				}
			}
		else {
            panel->backmapInfoHdl = GlobalAlloc(GHND,
              (1 << panel->backmapInfoHeader.biBitCount) * sizeof (RGBQUAD) +
              sizeof (BITMAPINFOHEADER));
            if (!(panel->backmapInfoHdl)) {
                sprintf(greet, "backdrop %s file backmapInfoHdl GlobalAlloc failure",
                  panel->backdrop);
                goto y;
				}
			}
        bitmapInfo = GlobalLock(panel->backmapInfoHdl);
        bitmapInfo->bmiHeader.biSize = panel->backmapInfoHeader.biSize;
        bitmapInfo->bmiHeader.biWidth = panel->backmapInfoHeader.biWidth;
        bitmapInfo->bmiHeader.biHeight = panel->backmapInfoHeader.biHeight;
        bitmapInfo->bmiHeader.biPlanes = panel->backmapInfoHeader.biPlanes;
        bitmapInfo->bmiHeader.biBitCount = panel->backmapInfoHeader.biBitCount;
        bitmapInfo->bmiHeader.biCompression = panel->backmapInfoHeader.biCompression;
        bitmapInfo->bmiHeader.biSizeImage = panel->backmapInfoHeader.biSizeImage;
        bitmapInfo->bmiHeader.biXPelsPerMeter = panel->backmapInfoHeader.biXPelsPerMeter;
        bitmapInfo->bmiHeader.biYPelsPerMeter = panel->backmapInfoHeader.biYPelsPerMeter;
        bitmapInfo->bmiHeader.biClrUsed = panel->backmapInfoHeader.biClrUsed;
        bitmapInfo->bmiHeader.biClrImportant = panel->backmapInfoHeader.biClrImportant;
        /*  read bitmap color table  */
        if (panel->backmapInfoHeader.biBitCount != 24) {
            if (!(ReadFile(file, bitmapInfo->bmiColors,
              (1 << panel->backmapInfoHeader.biBitCount) * sizeof (RGBQUAD), &l, 0)) || !l)
                goto z;
			}
        /*  Read in Map data  */
        if (!(panel->backmapHdl = GlobalAlloc(GHND,
          bitmapFileHeader.bfSize - bitmapFileHeader.bfOffBits)))
            goto z;
        map = GlobalLock(panel->backmapHdl);
        if (ReadFile(file, map, bitmapFileHeader.bfSize - bitmapFileHeader.bfOffBits, &l, 0)
          && l) {
        //  sprintf(greet, "Loading Backdrop %s for %s", panel->backdrop, panel->name);
        //  MessageBox(0, greet, szAppName, MB_OK | MB_TASKMODAL);
            GlobalUnlock(panel->backmapHdl);
            GlobalUnlock(panel->backmapInfoHdl);
            CloseHandle(file);
			}
		else {
            GlobalFree(panel->backmapHdl);
z:          GlobalFree(panel->backmapInfoHdl);
            panel->backmapHdl = 0;
            panel->backmapInfoHdl = 0;
y:          CloseHandle(file);
            }
        }
    }

        
ShowMessageBox(char *s) {
    MessageBox(0, s, szAppName, MB_OK | MB_TASKMODAL | MB_ICONINFORMATION);
    }

